// Product Detail Page Interactive Functions
document.addEventListener('DOMContentLoaded', function() {
    // Initialize Swiper Carousel
    const thumbSwiper = new Swiper('.royal-product-detail-swiper-thumbs', {
        spaceBetween: 8,
        slidesPerView: 4,
        freeMode: true,
        watchSlidesProgress: true,
        breakpoints: {
            768: { slidesPerView: 5 },
            480: { slidesPerView: 3 }
        }
    });

    new Swiper('.royal-product-detail-swiper-main', {
        spaceBetween: 10,
        navigation: {
            nextEl: '.royal-product-detail-swiper-button-next',
            prevEl: '.royal-product-detail-swiper-button-prev',
        },
        thumbs: { swiper: thumbSwiper }
    });

    // Initialize Tab Switching
    const tabNavs = document.querySelectorAll('.royal-product-detail-tab-nav');
    const tabPanels = document.querySelectorAll('.royal-product-detail-tab-panel');

    tabNavs.forEach(nav => {
        nav.addEventListener('click', function() {
            const targetTab = this.getAttribute('data-tab');
            
            // Remove all active states
            tabNavs.forEach(n => n.classList.remove('royal-product-detail-tab-active'));
            tabPanels.forEach(p => p.classList.remove('royal-product-detail-tab-active'));
            
            // Add current active state
            this.classList.add('royal-product-detail-tab-active');
            document.getElementById(`royal-product-detail-tab-${targetTab}`).classList.add('royal-product-detail-tab-active');
        });
    });

    // Add image zoom functionality
    const mainImages = document.querySelectorAll('.royal-product-detail-image');
    mainImages.forEach(img => {
        img.addEventListener('click', function() {
            this.classList.toggle('royal-zoomed');
        });
    });

    // Add quantity selector functionality
    const quantityInput = document.querySelector('.royal-quantity-input');
    const minusBtn = document.querySelector('.royal-quantity-minus');
    const plusBtn = document.querySelector('.royal-quantity-plus');

    if (quantityInput && minusBtn && plusBtn) {
        minusBtn.addEventListener('click', function() {
            let currentValue = parseInt(quantityInput.value);
            if (currentValue > 1) {
                quantityInput.value = currentValue - 1;
            }
        });

        plusBtn.addEventListener('click', function() {
            let currentValue = parseInt(quantityInput.value);
            quantityInput.value = currentValue + 1;
        });
    }

    // Add to cart functionality
    const addToCartBtn = document.querySelector('.royal-add-to-cart');
    if (addToCartBtn) {
        addToCartBtn.addEventListener('click', function() {
            const productName = document.querySelector('.royal-product-detail-title').textContent;
            const quantity = quantityInput ? quantityInput.value : 1;
            
            // Show success message
            royalShowNotification(`Added ${quantity} × ${productName} to cart`, 'success');
            
            // Add animation effect
            this.classList.add('royal-added');
            setTimeout(() => {
                this.classList.remove('royal-added');
            }, 2000);
        });
    }

    // Share functionality
    const shareBtn = document.querySelector('.royal-share-btn');
    if (shareBtn && navigator.share) {
        shareBtn.style.display = 'flex';
        shareBtn.addEventListener('click', async function() {
            try {
                await navigator.share({
                    title: document.title,
                    url: window.location.href
                });
            } catch (err) {
                console.log('Error sharing:', err);
            }
        });
    }

    // Favorite functionality
    const favoriteBtn = document.querySelector('.royal-favorite-btn');
    if (favoriteBtn) {
        favoriteBtn.addEventListener('click', function() {
            this.classList.toggle('royal-active');
            const isActive = this.classList.contains('royal-active');
            
            royalShowNotification(
                isActive ? 'Added to favorites' : 'Removed from favorites',
                isActive ? 'success' : 'info'
            );
        });
    }
});

// Notification function
function royalShowNotification(message, type = 'info') {
    // Remove existing notifications
    const existingNotifications = document.querySelectorAll('.royal-notification');
    existingNotifications.forEach(notification => notification.remove());

    const notification = document.createElement('div');
    notification.className = `royal-notification royal-${type}`;
    notification.innerHTML = `
        <div class="royal-notification-content">
            <i class="fas fa-${getNotificationIcon(type)}"></i>
            <span>${message}</span>
        </div>
    `;

    document.body.appendChild(notification);

    // Show notification
    setTimeout(() => notification.classList.add('royal-show'), 100);

    // Auto hide after 3 seconds
    setTimeout(() => {
        notification.classList.remove('royal-show');
        setTimeout(() => notification.remove(), 300);
    }, 3000);
}

function getNotificationIcon(type) {
    const icons = {
        success: 'check-circle',
        error: 'exclamation-circle',
        warning: 'exclamation-triangle',
        info: 'info-circle'
    };
    return icons[type] || 'info-circle';
}