# RoyalCMS 若伊智能网站构建系统

# RoyalCMS 安装说明

## 快速开始

1. **设置网站根目录**：将网站根目录设置为 `public` 目录
2. **访问安装程序**：在浏览器中输入对应网址即可自动进入安装程序
3. **按照向导完成安装**：
   - 环境检测
   - 数据库配置
   - 系统安装

## 安装后安全操作（必须完成！）

**重要提示**：安装完成后必须立即完成以下安全操作，否则系统可能被他人重新安装！

### 操作步骤（按顺序执行）：

1. **删除安装目录**
   - 删除整个 `/public/install/` 目录
   - 操作：`rm -rf /public/install/`

2. **删除原始入口文件**
   - 删除网站根目录的 `index.php`
   - 操作：`rm /public/index.php`

3. **重命名备份文件**
   - 将 `index_bak.php` 重命名为 `index.php`
   - 操作：`mv /public/index_bak.php /public/index.php`

4. **立即修改默认密码**
   - 使用以下信息登录后台：
     - 后台地址：`/royalcms/website/login/index`
     - 测试账号：`demo`
     - 测试密码：`123456`
   - **登录后立即修改密码**！

## 安装故障处理
### 如果需要重新安装：

1. **清理数据库**：
   ```sql
   DROP DATABASE [数据库名];
   ```
2. **删除文件**：
   - 删除所有已上传文件
   - 重新上传原始安装包

3. **删除安装锁文件**：
   - 删除 `runtime/install.lock` 文件

4. **重新运行安装程序**：
   - 访问网站首页重新开始安装
**警告**：未完成安全操作前，系统处于不安全状态，请务必按顺序完成所有安全操作！





## 1. 系统简介

RoyalCMS 是一款基于 **ThinkPHP 8.0 + LayUI** 开发的免费开源内容管理系统。系统专注于为企业官网、资讯门户、教育机构等场景提供简洁高效的网站建设解决方案。

**核心特性**：
- 完全开源免费（MIT协议）
- 完整中英双语支持
- 轻量高效，快速部署
- 企业级安全保障
- 响应式多端适配
- 优雅的后台界面

**技术栈**：
- 后端：PHP 8.0+ + ThinkPHP 8.0
- 前端：LayUI + HTML5/CSS3
- 数据库：MySQL 5.7+/8.0+
- 环境要求：Apache/Nginx + Composer

## 2. 演示与文档

### 在线演示
- **演示网站**：[http://demo.royalcms.com.cn](http://demo.royalcms.com.cn)
- **演示后台**：[http://demo.royalcms.com.cn/royalcms/website/login/index](http://demo.royalcms.com.cn/royalcms/website/login/index)
- **演示账号**：demo
- **演示密码**：123456

### 开发文档
完整的使用说明、安装指南、API文档请访问：
- **开发文档**：[http://www.royalcms.com.cn/doc.html](http://www.royalcms.com.cn/doc.html)

## 3. 版权与免责

### 版权声明
RoyalCMS 采用 **MIT 开源协议**，您可以：
- ✅ 免费用于商业项目
- ✅ 修改和二次开发
- ✅ 私有化部署
- ❌ 但禁止直接售卖源码
- ❌ 禁止去除版权信息

### 免责声明
1. RoyalCMS 是免费开源软件，不提供任何形式的担保
2. 用户需自行承担使用风险
3. 禁止用于任何违法或侵权用途
4. 系统基于 ThinkPHP、LayUI 等开源技术构建

**版权所有** © 2014-2025 RoyalCMS Team

--- 